# The Cormorant Typeface Project

Cormorant is a free display type family developed by Christian Thalmann ([Catharsis Fonts][1]).  It comprises a total of 30 font files spanning 6 different styles (Roman, Italic, Upright Cursive, Roman Infant, Small Caps, Unicase) and 5 weights (Light, Regular, Medium, Semibold, Bold).  For an illustrated presentation and description of the family, **please visit [its Bēhance page][3]**.

Cormorant is open source, and all its working files (in [Glyphs][2] format) are available from this repository. If you wish to work with Cormorant in a different font editor (which I wouldn't recommend), I can provide you with UFO versions of those files instead.

Any feedback, bug reports, test results, and suggestions for additions are very welcome. You can contact me using the [Cormorant issue tracker][4]. 

If you like Cormorant, please help spread the word via the social media of your choice. You might also be interested in my other typefaces on [MyFonts][1].

### Installation

If you wish to use the Cormorant type family on your computer, simply download the "Cormorant_Install" ZIP file from the [latest release][5], unpack it, and install the OpenType font files (.otf) as appropriate for your operating system.

**Coming soon:** If you wish to use the Cormorant type family on your website, it will soon be available from [Google Fonts][10]. 

### License
 
The Cormorant typeface and all its associated font files are free software under the [SIL Open Font License][10]. Essentially, this gives you the right to download, use, and redistribute the fonts as you like, provided that 

1. you retain my copyright notices;
2. you do not redistribute this software without this license information; and 
3. you do not redistribute the fonts by themselves for a fee (though you are allowed to sell them as part of a bundle containing other items.)

### Acknowledgements
 
Cormorant was conceived, drawn, spaced, kerned, programmed, interpolated, and produced in its entirety by myself (Christian Thalmann, [Catharsis Fonts][1]). I did all the work with [Glyphs][2], which I consider the world's best font editing software. It's not free, but it's worth every penny ten times over; I cannot recommend it enough. I used the public beta version of the RMX Harmonizer plug-in to ensure curve quality.
 
While this project was heavily inspired by [Claude Garamont][6]'s immortal legacy, I did not use any specific font as a starting point or direct reference for my designs. Most glyphs were drawn from scratch; when I needed guidance on a specific character, I searched [MyFonts](https://www.myfonts.com/) for the term «Garamond» and skimmed through the results for a general impression.
 
I am very grateful to the creative souls on the [TypeDrawers][7] forum and the (late?) [Typophile][8] forum for teaching me all I know about type design in the first place, and for providing me with a large amount of excellent feedback on Cormorant in particular. Likewise, my gratitude goes to the tireless folks at [Glyphs][2] — in particular Rainer Erich Scheichelbauer (Mekka Blue, [Schriftlabor][9]) and Georg Seifert — for the creation and support of their magnificent engine. Special thanks go to Dave Crossland and [Google Fonts][10] for making the libre release of this font family possible through generous funding of the development process. 

[1]: https://www.myfonts.com/foundry/Catharsis_Fonts
[2]: https://glyphsapp.com
[3]: https://www.behance.net/gallery/28579883/Cormorant-an-open-source-display-font-family
[4]: https://github.com/CatharsisFonts/Cormorant/issues/
[5]: https://github.com/CatharsisFonts/Cormorant/releases/latest
[6]: https://en.wikipedia.org/wiki/Claude_Garamond
[7]: http://typedrawers.com
[8]: http://typophile.com
[9]: http://schriftlabor.at
[10]: http://scripts.sil.org/OFL
